﻿using System.Collections.Generic;

namespace StokYonetimSistemi.Entities
{
    public class Urun
    {
        public int Id { get; set; }
        public string Ad { get; set; }
        public string Marka { get; set; }
        public string Model { get; set; }
        public string Barkod { get; set; }
        public decimal? AlisFiyati { get; set; }
        public decimal SatisFiyati { get; set; }
        public int StokAdedi { get; set; }
        public bool AktifMi { get; set; }

        // Foreign Key
        public int KategoriId { get; set; }
        // İlişkisel property
        public virtual Kategori Kategori { get; set; }
        public virtual ICollection<StokHareketi> StokHareketleri { get; set; }

        public Urun()
        {
            StokHareketleri = new HashSet<StokHareketi>();
        }
    }
}